#include <a_samp>
//#include <DOF2>
#include ZCMD

/* Projeto de Faculdade para servidores Roleplay;
	* Desenvolvedor: ProKillerPa( Gabriel Buttenbender );
*/

//new AllAlunos;

enum Facul{
	Nome[MAX_PLAYER_NAME],
	Inscricao,
	Curso,
	Mensalidade,
	MensaNaoPagas,
	AulasGazeadas,
	AulasPresente

}; new Faculdade[MAX_PLAYERS][Facul];

forward CarregarDados(playerid);
forward FazerIncricao(playerid);
forward TotalAlunos();
forward AumentarAlunos();
forward CancelarMatricula(playerid);
forward PagarMensalidade(playerid);
forward GazearAula(playerid);
forward AssistirAula(playerid);
forward LiberarAulas();
forward TrancarAulas(playerid);
forward TerminarAula(playerid);
forward DiminuirAlunos();

// Forward Complementares

forward VirarMedico(playerid);

#define DIALOG_MENUFACUL 1
#define DIALOG_ACAOFACUL 2
#define DIALOG_MATRICULAOK 3
#define DIALOG_CURSOFACUL 4

#define DIALOG_ACCMEDIC 5
#define DIALOG_PEGOUMEDICO 6

#define DIALOG_PAGOMENSA 7
#define DIALOG_SEMGRANAMATRI 8

//

#define AULASGAZEADAS 8
#define TEMPOSEMAULA  60// MINUTOS
#define TEMPOAULA 10
new GranaJogador[MAX_PLAYERS],
	Calculo[MAX_PLAYERS]
;

new AulaLiberada = 0;

new String[256];

CMD:faculdade(playerid){
	if(IsPlayerInRangeOfPoint(playerid, 3.0, 1158.5186,-604.1557,1089.9259)){
		ShowPlayerDialog(playerid, DIALOG_MENUFACUL, DIALOG_STYLE_MSGBOX, "{BEBEBE}Faculdade de Los Santos", "{BEBEBE}Bem vindo  {FFFF00}UFLS{BEBEBE}, Universidade Federal de Los Santos!\n\n{BEBEBE}Caso deseja fazer uma matricula, clique no boto {FFFF00}prosseguir {BEBEBE}e siga os passos pedidos.\n\nCaso esteja apenas de passagem, clique no boto {FFFF00}Sair{BEBEBE}.", "Prosseguir", "Fechar");
	} else SendClientMessage(playerid, -1, "{BEBEBE}| INFO | Voc no est no balco da universidade");
	return 1;
}

public GazearAula(playerid){
	new AlunoNome[MAX_PLAYER_NAME], Str[400];

	GetPlayerName(playerid, AlunoNome, MAX_PLAYER_NAME);

	format(String, sizeof(String), "Faculdade/Alunos/%s.ini", AlunoNome);

    if(!DOF2_FileExists(String)) return SendClientMessage(playerid, -1, "| INFO | Voc no possui uma matricula!");

    if(Faculdade[playerid][AulasGazeadas] >= AULASGAZEADAS){
        SendClientMessage(playerid, -1, "{BEBEBE}| INFO | Voc Gazeou o mximo de aulas possveis, voc foi expulso da {FFFF00}UFLS!");

        CancelarMatricula(playerid);
        DiminuirAlunos();
	} else{


		DOF2_SetInt(AlunoNome, "AulasGazeadas", Faculdade[playerid][AulasGazeadas] + 1);

		DOF2_SaveFile();

		format(Str, sizeof(Str), "{BEBEBE}A Universidade informa  {32CD32}%s!\n\n{BEBEBE}Voc possui {32CD32}%d{BEBEBE} Aulas Gazeadas, caso exceda 8 {BEBEBE}voc ser {FF0000}expulso!\n\n{FFFF00}Tenha uma boa tarde!", AlunoNome);
		ShowPlayerDialog(playerid, DIALOG_SEMGRANAMATRI, DIALOG_STYLE_MSGBOX, "{FFFF00}UFLS{BEBEBE} - Gazear Aula", Str, "Fechar", "");
	}
	return 1;
}

public PagarMensalidade(playerid){
	new AlunoNome[MAX_PLAYER_NAME];

	GetPlayerName(playerid, AlunoNome, MAX_PLAYER_NAME);

	format(String, sizeof(String), "Faculdade/Alunos/%s.ini", AlunoNome);

	if(!DOF2_FileExists(String)) return SendClientMessage(playerid, -1, "| INFO | Voc no possui uma matricula!");

	if(Faculdade[playerid][MensaNaoPagas] >= 1){
	    GranaJogador[playerid] = GetPlayerMoney(playerid);
	    Calculo[playerid] = Faculdade[playerid][MensaNaoPagas] * Faculdade[playerid][Mensalidade];

	    if(GranaJogador[playerid] <= Calculo[playerid]) return ShowPlayerDialog(playerid, DIALOG_SEMGRANAMATRI, DIALOG_STYLE_MSGBOX, "{FFFF00}UFLS{BEBEBE} - Mensalidade", "{BEBEBE}A Universidade Informa:\n\nDinheiro no correspondente ao total da parcela.\n\n{FA8072}Pagamento Cancelado.", "Fechar", "");
	    GivePlayerMoney(playerid, GranaJogador[playerid] - Calculo[playerid]);

	    format(String, sizeof(String), "{BEBEBE}Mensalidade paga com sucesso!\n\nParcelas Acumuladas: {FA8072}%d\n{BEBEBE}Mensalidade Curso: {32CD32}R$%d,00\n{BEBEBE}Total Pago: {32CD32}R$%d,00", Faculdade[playerid][MensaNaoPagas], Faculdade[playerid][Mensalidade], Calculo[playerid]);
	    ShowPlayerDialog(playerid, DIALOG_PAGOMENSA, DIALOG_STYLE_MSGBOX, "{FFFF00}UFLS{BEBEBE} - Mensalidade", String, "Fechar", "");

	    DOF2_SetInt(AlunoNome, "MensaNaoPagas", 0);

	    DOF2_SaveFile();

	    CarregarDados(playerid);
	    Faculdade[playerid][MensaNaoPagas] = 0;

	} else SendClientMessage(playerid, -1, "| INFO | Voc est com sua matricula paga em dia! Parabns!!");
	return 1;
}

public CancelarMatricula(playerid){
	new AlunoNome[MAX_PLAYER_NAME];

	GetPlayerName(playerid, AlunoNome, MAX_PLAYER_NAME);

	format(String, sizeof(String), "Faculdade/Alunos/%s.ini", AlunoNome);

	DOF2_RemoveFile(String);
	DiminuirAlunos();

	printf("[LOG] O(A) Cursando %s cancelou seu estudo na faculdade", AlunoNome);

	SendClientMessage(playerid, -1, "{BEBEBE}| INFO | Voc cancelou os seus estudos, pense bem da prxima vez!");
	return 1;
}

public OnDialogResponse(playerid, dialogid, response, listitem, inputtext[]){
	if(dialogid == DIALOG_MENUFACUL){
	    if(!response) return 1;

		ShowPlayerDialog(playerid, DIALOG_ACAOFACUL, DIALOG_STYLE_LIST, "{FFFF00}UFLS - {BEBEBE}Menu", "{BEBEBE}Fazer Matricula\n{BEBEBE}Cancelar Matricula\n{BEBEBE}Pagar Mensalidade\n{BEBEBE}Gazear Aula\n{BEBEBE}Assistir Aula", "Prosseguir", "Sair");
	}
	if(dialogid == DIALOG_ACAOFACUL){
	    if(!response) return 1;

		switch(listitem){
			case 0: FazerIncricao(playerid);
			case 1: CancelarMatricula(playerid);
			case 2: PagarMensalidade(playerid);
			case 3: GazearAula(playerid);
			case 4: AssistirAula(playerid);
		}
	}
	if(dialogid == DIALOG_MATRICULAOK){
		if(!response) return 1;

		ShowPlayerDialog(playerid, DIALOG_CURSOFACUL, DIALOG_STYLE_LIST, "{FFFF00}UFLS{BEBEBE} - Cursos", "{BEBEBE}Medico\n{BEBEBE}Advogado\n{BEBEBE}Cientista\n{BEBEBE}Historiador\nProfessor", "Continuar", "Fechar");
	}
	if(dialogid == DIALOG_CURSOFACUL){
	    if(!response) return ShowPlayerDialog(playerid, DIALOG_CURSOFACUL, DIALOG_STYLE_LIST, "{FFFF00}UFLS{BEBEBE} - Cursos", "{BEBEBE}Medico\n{BEBEBE}Advogado\n{BEBEBE}Cientista\n{BEBEBE}Historiador", "Continuar", "Fechar");

	    switch(listitem){
	        case 0: ShowPlayerDialog(playerid, DIALOG_ACCMEDIC, DIALOG_STYLE_MSGBOX, "{FFFF00}UFLS {BEBEBE}- Curso Mdico", "{BEBEBE}O Curso mdico foi selecionado!\n\nCaso no seja esse o curso desejado, clique em voltar e selecione outro.\n\nEsteja ciente que o valor da mensalidade desse curso  de {32CD32}R$4000,00\n\n{BEBEBE}Caso no consiga pagar perder o curso.\n\n{FFFF00}Selecione{BEBEBE} uma opo abaixo para continuar!", "Continuar", "Voltar");
	    }
	}
	if(dialogid == DIALOG_ACCMEDIC){
	    if(!response) return ShowPlayerDialog(playerid, DIALOG_CURSOFACUL, DIALOG_STYLE_LIST, "{FFFF00}UFLS{BEBEBE} - Cursos", "{BEBEBE}Medico\n{BEBEBE}Advogado\n{BEBEBE}Cientista\n{BEBEBE}Historiador", "Continuar", "Fechar");

		ShowPlayerDialog(playerid, DIALOG_PEGOUMEDICO, DIALOG_STYLE_MSGBOX,"{FFFF00}UFLS {BEBEBE}- Curso Mdico", "{FFFF00}Parabns, {BEBEBE}Daqui em diante voc cursar a faculdade de medicina!\n\nNo esquea de pagar a {FFFF00}Mensalidade,{BEBEBE} para pagar apenas selecione a opo no menu.\n\n{FA8072}Curso: {BEBEBE}Mdico\n{FA8072}Mensalidade: {32CD32}R$4000,00\n\n", "Finalizar", "Voltar");

		new AlunoNome[MAX_PLAYER_NAME];

		GetPlayerName(playerid, AlunoNome, MAX_PLAYER_NAME);

		format(String, sizeof(String), "Faculdade/Alunos/%s.ini", AlunoNome);

		DOF2_SetString(String, "Curso", "Medicina");
		DOF2_SetInt(String, "Mensalidade", 4000);

		DOF2_SaveFile();

		CarregarDados(playerid);

	}
	return 1;
}

public AumentarAlunos(){
	new Alunos[60];

	format(Alunos, sizeof(Alunos), "Faculdade/TotalAlunos.ini");

	new get = DOF2_GetInt(Alunos, "TotalAlunos");
	get ++;

	DOF2_SetInt(Alunos, "TotalAlunos", get);

	DOF2_SaveFile();

	get = 0;
	return 1;
}

public DiminuirAlunos(){
	new Alunos[60];

	format(Alunos, sizeof(Alunos), "Faculdade/TotalAlunos.ini");

	new get = DOF2_GetInt(Alunos, "TotalAlunos");

	DOF2_SetInt(Alunos, "TotalAlunos", get-1);

	DOF2_SaveFile();

	get = 0;

	return 1;
}



public TotalAlunos(){
	new Alunos[60];

	format(Alunos, sizeof(Alunos), "Faculdade/TotalAlunos.ini");

	if(!DOF2_FileExists(Alunos)){
	    DOF2_CreateFile(Alunos);

	    DOF2_SetInt(Alunos, "TotalAlunos", 0);

	    DOF2_SaveFile();
	} else {
		print("[LOG] O Arquivo TotalAlunos est criado na pasta solicitada. Carregando Dados...");

        //AllAlunos = DOF2_GetInt(Alunos, "TotalAlunos");

        print("Dados obtidos. Filterscript Liberado.");
	}
	return 1;
}

public CarregarDados(playerid){
	new AlunoNome[MAX_PLAYER_NAME];

	GetPlayerName(playerid, AlunoNome, MAX_PLAYER_NAME);

	format(String, sizeof(String), "Faculdade/Alunos/%s.ini", AlunoNome);


	format(Faculdade[playerid][Nome], 126, "%s", DOF2_GetString(String, "Aluno"));
	format(Faculdade[playerid][Curso], 126, "%s", DOF2_GetString(String, "Curso"));

	Faculdade[playerid][Inscricao] = DOF2_GetInt(String, "Matricula");

	Faculdade[playerid][Mensalidade] = DOF2_GetInt(String, "Mensalidade");
	Faculdade[playerid][MensaNaoPagas] = DOF2_GetInt(String, "MensaNaoPagas");

	Faculdade[playerid][AulasGazeadas] = DOF2_GetInt(String, "AulasGazeadas");

	Faculdade[playerid][AulasPresente] = DOF2_GetInt(String, "AulasPresente");

	printf("[LOG] O Jogador %s carregou os seus dados da faculdade com sucesso!", AlunoNome);
 	return 1;
}

public FazerIncricao(playerid){
	new AlunoNome[MAX_PLAYER_NAME];

	GetPlayerName(playerid, AlunoNome, MAX_PLAYER_NAME);

	format(String, sizeof(String), "Faculdade/Alunos/%s.ini", AlunoNome);

	if(!DOF2_FileExists(String)){
	    DOF2_CreateFile(String);

	    DOF2_SetString(String, "Aluno", AlunoNome);
		DOF2_SetString(String, "Curso", "No Escolhido");

		new Matricula;
  		Matricula = random(9000);

	    DOF2_SetInt(String, "Matricula", Matricula);

	    DOF2_SetInt(String, "Mensalidade", 0);
	    DOF2_SetInt(String, "MensaNaoPagas", 0);

	    DOF2_SetInt(String, "AulasGazeadas", 0);

		DOF2_SetInt(String, "AulasPresente", 0);

	    DOF2_SaveFile();

		AumentarAlunos();

	    new Matr[400]
	        ;

	    format(Matr, sizeof(Matr), "{BEBEBE}Matricula realizada com sucesso!\n\n{BEBEBE}Seja bem vindo  {FFFF00}Universidade Federal de Los Santos!!\n\n{BEBEBE}Veja abaixo os dados da sua matricula:\n\n{BEBEBE}Universitario: {FA8072}%s\n{BEBEBE}Curso: {FA8072}No Escolhido\n{BEBEBE}Matricula: {FA8072}%d", AlunoNome,Matricula);
	    ShowPlayerDialog(playerid, DIALOG_MATRICULAOK, DIALOG_STYLE_MSGBOX, "{FFFF00}UFLS {BEBEBE}- Matricula", Matr, "Prosseguir", "Sair");
	} else SendClientMessage(playerid, -1, "{BEBEBE}| ERRO | Impossvel realizar a incrio, o jogador j possui uma!"),
           ShowPlayerDialog(playerid, DIALOG_ACAOFACUL, DIALOG_STYLE_LIST, "{FFFF00}UFLS - {BEBEBE}Menu", "{BEBEBE}Fazer Matricula\n{BEBEBE}Cancelar Matricula\n{BEBEBE}Pagar Mensalidade\n{BEBEBE}Gazear Aula\n", "Prosseguir", "Sair")
		;
	return 1;
}

public TrancarAulas(playerid){
    AulaLiberada = 0;

	SendClientMessageToAll(-1, "| UFLS | As aulas foram encerradas! Aguarde em torno de 40 minutos para ela re-abrila!");
	SendClientMessageToAll(-1, "| UFLS | Caso voc no informou sua falta na faculdade, a sua punio foi mais severa.");

	new AlunoNome[MAX_PLAYER_NAME];

	GetPlayerName(playerid, AlunoNome, MAX_PLAYER_NAME);

	format(String, sizeof(String), "Faculdade/Alunos/%s.ini", AlunoNome);

	DOF2_SetInt(String, "AulasGazeadas", Faculdade[playerid][AulasGazeadas] + 2);

	DOF2_SaveFile();
	return 1;
}

new LiberadoPraSair[MAX_PLAYERS];

public AssistirAula(playerid){
	if(AulaLiberada == 0) return SendClientMessage(playerid, -1, "| INFO | As aulas no esto liberadas agora, aguarde o seu abrimento!");

	SetPlayerPos(playerid, 1161.0154,-613.2623,1089.9259);
	SendClientMessage(playerid, -1, "| INFO | Assita a sua aula, quando o tempo acabar voc poder sair da faculadade.");

	LiberadoPraSair[playerid] = 2; // 2 = FALSE - 1 = TRUE
	SetTimerEx("TerminarAula", 60000*TEMPOAULA, true, "i", "playerid");
	return 1;
}

public TerminarAula(playerid){
	new AlunoNome[MAX_PLAYER_NAME];

	GetPlayerName(playerid, AlunoNome, MAX_PLAYER_NAME);

	format(String, sizeof(String), "Faculdade/Alunos/%s.ini", AlunoNome);

	DOF2_SetInt(String, "AulasPresente", Faculdade[playerid][AulasPresente] + 1);

	DOF2_SaveFile();

	LiberadoPraSair[playerid] = 1; // TRUE

	CarregarDados(playerid);

	if(Faculdade[playerid][AulasPresente] == 15){
	    VirarMedico(playerid);
	}

	return 1;
}

public LiberarAulas(){
	AulaLiberada = 1;

	SendClientMessageToAll(-1, "| UFLS | As aulas foram iniciadas! Ela se fechar em 15 minutos!");
	SendClientMessageToAll(-1, "| UFLS | Caso no possa assistir a aula, informe 'Gazear Aula', caso contrrio contar 2 aulas gazeadas.");
	SetTimer("TrancarAulas", 15*60000, false);
	return 1;
}

public OnPlayerKeyStateChange(playerid, newkeys, oldkeys)
{
	if(newkeys == 16 && GetPlayerState(playerid) == PLAYER_STATE_ONFOOT) {
 		if (IsPlayerInRangeOfPoint(playerid, 2.0, 1146.1642,-601.3550,1089.9259)){
 		    if(LiberadoPraSair[playerid] == 2) return 1;
 		    SetPlayerPos(playerid, 1081.2217,-1697.2777,13.5469);
   		}
     	else if (IsPlayerInRangeOfPoint(playerid, 3.0, 1081.2217,-1697.2777,13.5469)){
     		if(LiberadoPraSair[playerid] == 2) return 1;
      		SetPlayerPos(playerid, 1146.1642,-601.3550,1089.9259);
        }
    }
    return 1;
}

public VirarMedico(playerid){
	// Coloque aqui as funes/variaveis que d medico para o player.
	return 1;
}

public OnFilterScriptInit(){
    AddPlayerClass(0, 1930.3783, 1343.1572, 15.3746, 269.1425, 0, 0, 0, 0, 0, 0);

    TotalAlunos();

    SetTimer("LiberarAulas", TEMPOSEMAULA*60000, true);

    AddStaticPickup(1314, 1, 1081.2217,-1697.2777,13.5469, -1); // ent
    Create3DTextLabel("{BEBEBE}Faculdade {FA8072}UFLS\n{BEBEBE}Pressione '{FFFF00}F{BEBEBE}' para Entrar!", 0x008080FF, 1081.2217,-1697.2777,13.5469, 40.0, 0, 0);

    AddStaticPickup(1314, 1, 1146.1642,-601.3550,1089.9259, -1); // exit
    Create3DTextLabel("{BEBEBE}Faculdade {FA8072}UFLS\n{BEBEBE}Pressione '{FFFF00}F{BEBEBE}' para Sair!", 0x008080FF, 1146.1642,-601.3550,1089.9259, 40.0, 0, 0);

	CreateObject(19369, 1155.08, -626.00, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1156.60, -627.65, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1159.78, -627.66, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1162.98, -627.66, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19379, 1160.40, -622.78, 1088.84,   0.00, 90.00, 0.00);
	CreateObject(1502, 1155.08, -624.44, 1088.88,   0.00, 0.00, 90.00);
	CreateObject(1502, 1155.02, -621.41, 1088.88,   0.00, 0.00, 270.00);
	CreateObject(19369, 1166.17, -627.66, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1165.69, -626.03, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1165.70, -622.82, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1165.69, -619.62, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1164.06, -617.93, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1160.86, -617.93, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1157.66, -617.92, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1155.04, -619.82, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1155.05, -616.62, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1156.60, -617.94, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1155.06, -613.97, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(1502, 1155.09, -612.39, 1088.88,   0.00, 0.00, 90.00);
	CreateObject(1502, 1155.04, -609.35, 1088.88,   0.00, 0.00, 270.00);
	CreateObject(19379, 1160.34, -613.04, 1088.84,   0.00, 90.00, 0.00);
	CreateObject(19369, 1165.67, -616.30, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1165.67, -613.10, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1165.66, -609.92, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1164.07, -608.38, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1160.88, -608.37, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1157.68, -608.38, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1156.02, -608.36, 1090.44,   0.00, 0.00, 90.00);
	CreateObject(19369, 1155.03, -607.78, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1156.56, -629.36, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1156.55, -633.01, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1158.12, -634.53, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1159.63, -632.92, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1159.63, -629.74, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1161.29, -628.03, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1164.49, -628.03, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1167.70, -628.04, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1168.93, -629.61, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1168.93, -632.78, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1168.93, -635.96, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(1999, 1164.09, -623.69, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1714, 1165.18, -623.17, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(1999, 1164.09, -613.57, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1714, 1165.15, -613.15, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(14455, 1164.83, -628.32, 1090.41,   0.00, 0.00, 180.00);
	CreateObject(14455, 1171.05, -628.38, 1090.41,   0.00, 0.00, 180.00);
	CreateObject(2001, 1165.82, -628.36, 1088.93,   0.00, 0.00, 0.00);
	CreateObject(19369, 1167.43, -637.66, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1159.65, -636.19, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1161.29, -637.71, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(1502, 1162.83, -637.72, 1088.93,   0.00, 0.00, 0.00);
	CreateObject(1502, 1165.85, -637.67, 1088.93,   0.00, 0.00, 180.00);
	CreateObject(4604, 1314.80, -569.12, 1093.00,   -0.05, 179.22, 9.44);
	CreateObject(19369, 1170.65, -637.65, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1173.86, -637.65, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1175.38, -635.96, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1180.23, -636.38, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1180.22, -633.18, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1181.73, -631.49, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1175.39, -632.77, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1175.38, -629.57, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1177.04, -628.04, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1181.82, -626.82, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1184.98, -626.82, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1180.21, -628.33, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(1502, 1180.16, -629.89, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(3851, 1180.14, -629.97, 1093.44,   0.00, 0.00, 0.00);
	CreateObject(19369, 1184.75, -631.47, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1186.35, -632.78, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1188.64, -628.37, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1188.18, -626.80, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(1998, 1186.86, -628.58, 1088.93,   0.00, 0.00, 0.00);
	CreateObject(1727, 1179.44, -632.20, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(2001, 1179.89, -631.69, 1088.93,   0.00, 0.00, 0.00);
	CreateObject(2001, 1179.86, -628.47, 1088.93,   0.00, 0.00, 0.00);
	CreateObject(1727, 1179.42, -633.64, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(1727, 1179.43, -635.07, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(1727, 1179.42, -636.43, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(2001, 1179.86, -637.81, 1088.93,   0.00, 0.00, 0.00);
	CreateObject(19369, 1180.23, -639.59, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(0, 1178.13, -635.76, 1088.93,   0.00, 0.00, 0.00);
	CreateObject(1827, 1177.17, -635.01, 1088.93,   0.00, 0.00, 0.00);
	CreateObject(1727, 1178.16, -628.85, 1088.93,   0.00, 0.00, 0.00);
	CreateObject(1727, 1176.57, -628.85, 1088.93,   0.00, 0.00, 0.00);
	CreateObject(2001, 1175.81, -628.44, 1088.93,   0.00, 0.00, 0.00);
	CreateObject(19369, 1178.01, -641.10, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1174.81, -641.11, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(1726, 1168.16, -630.15, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(1726, 1168.19, -632.74, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(2001, 1168.30, -635.48, 1088.93,   0.00, 0.00, 0.00);
	CreateObject(1827, 1165.63, -633.96, 1088.93,   0.00, 0.00, 0.00);
	CreateObject(1827, 1165.95, -631.38, 1088.93,   0.00, 0.00, 0.00);
	CreateObject(2894, 1165.73, -634.22, 1089.35,   0.00, 0.00, 90.00);
	CreateObject(2894, 1165.55, -633.79, 1089.35,   0.00, 0.00, 90.00);
	CreateObject(2894, 1166.41, -631.45, 1089.35,   0.00, 0.00, 90.00);
	CreateObject(2894, 1164.11, -623.68, 1089.74,   0.00, 0.00, 90.00);
	CreateObject(2894, 1164.16, -613.42, 1089.74,   0.00, 0.00, 90.00);
	CreateObject(2894, 1165.91, -633.61, 1089.35,   0.00, 0.00, 90.00);
	CreateObject(2894, 1166.00, -630.95, 1089.35,   0.00, 0.00, 90.00);
	CreateObject(14455, 1159.94, -632.51, 1090.47,   0.00, 0.00, 270.00);
	CreateObject(2001, 1160.01, -631.63, 1088.93,   0.00, 0.00, 0.00);
	CreateObject(2002, 1160.22, -630.96, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(2007, 1160.29, -629.93, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1726, 1163.76, -632.29, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1726, 1163.78, -634.83, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(19369, 1150.19, -626.74, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1150.19, -629.93, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1148.56, -631.44, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1148.59, -634.62, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1150.07, -636.31, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1151.41, -639.17, 1090.43,   0.00, 0.00, 60.00);
	CreateObject(19369, 1154.34, -639.50, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1155.90, -641.02, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1157.54, -641.16, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1160.72, -641.14, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1166.89, -641.14, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(1502, 1162.29, -641.15, 1088.93,   0.00, 0.00, 0.00);
	CreateObject(1502, 1165.29, -641.10, 1088.93,   0.00, 0.00, 180.00);
	CreateObject(19369, 1170.09, -641.14, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(1502, 1171.69, -641.11, 1088.93,   0.00, 0.00, 0.00);
	CreateObject(19369, 1181.23, -641.11, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(3851, 1165.01, -637.71, 1093.41,   0.00, 0.00, 90.00);
	CreateObject(1649, 1172.68, -641.10, 1093.10,   0.00, 0.00, 0.00);
	CreateObject(19369, 1170.10, -642.76, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1171.09, -645.46, 1090.43,   0.00, 0.00, 40.00);
	CreateObject(19369, 1173.09, -645.36, 1090.43,   0.00, 0.00, -40.00);
	CreateObject(19369, 1174.06, -642.69, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(4604, 1162.21, -626.68, 1088.93,   0.00, 0.00, 0.00);
	CreateObject(4604, 1162.23, -626.68, 1092.01,   0.00, 180.00, 0.00);
	CreateObject(19369, 1149.41, -608.39, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1150.20, -623.59, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1150.19, -620.39, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1150.23, -614.04, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1150.29, -607.89, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(1649, 1172.66, -641.07, 1093.10,   0.00, 180.00, 0.00);
	CreateObject(3515, 1152.36, -637.07, 1088.91,   0.00, 0.00, 0.00);
	CreateObject(19369, 1150.08, -639.49, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1151.15, -639.50, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(970, 1152.32, -634.75, 1089.46,   0.00, 0.00, 0.00);
	CreateObject(970, 1154.63, -637.27, 1089.46,   0.00, 0.00, 90.00);
	CreateObject(2001, 1154.56, -634.97, 1088.88,   0.00, 0.00, 0.00);
	CreateObject(14455, 1156.29, -633.46, 1090.48,   0.00, 0.00, 90.00);
	CreateObject(14455, 1156.71, -640.92, 1090.48,   0.00, 0.00, 0.00);
	CreateObject(2001, 1162.08, -640.86, 1088.91,   0.00, 0.00, 0.00);
	CreateObject(2001, 1165.45, -640.89, 1088.91,   0.00, 0.00, 0.00);
	CreateObject(14455, 1166.30, -640.89, 1090.48,   0.00, 0.00, 0.00);
	CreateObject(2001, 1171.55, -640.92, 1088.91,   0.00, 0.00, 0.00);
	CreateObject(2001, 1173.49, -640.91, 1088.91,   0.00, 0.00, 0.00);
	CreateObject(1744, 1170.05, -643.27, 1090.47,   0.00, 0.00, 90.00);
	CreateObject(1750, 1170.05, -643.27, 1090.79,   0.00, 0.00, 90.00);
	CreateObject(1775, 1158.18, -635.06, 1090.00,   0.00, 0.00, 0.00);
	CreateObject(2001, 1159.28, -635.02, 1088.91,   0.00, 0.00, 0.00);
	CreateObject(3851, 1155.09, -620.72, 1093.37,   0.00, 0.00, 0.00);
	CreateObject(3851, 1155.02, -613.00, 1093.37,   0.00, 0.00, 0.00);
	CreateObject(3851, 1163.13, -641.13, 1093.41,   0.00, 0.00, 90.00);
	CreateObject(19369, 1147.08, -636.29, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1147.08, -639.48, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1147.07, -642.68, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1145.39, -644.17, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1142.19, -644.17, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1139.02, -644.17, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1145.43, -637.93, 1088.23,   0.00, 0.00, 90.00);
	CreateObject(19369, 1142.23, -637.94, 1088.23,   0.00, 0.00, 90.00);
	CreateObject(19369, 1139.03, -637.94, 1088.23,   0.00, 0.00, 90.00);
	CreateObject(19369, 1137.51, -639.64, 1088.23,   0.00, 0.00, 0.00);
	CreateObject(19369, 1137.51, -640.49, 1088.22,   0.00, 0.00, 0.00);
	CreateObject(1502, 1137.48, -642.05, 1087.47,   0.00, 0.00, 270.00);
	CreateObject(19369, 1135.85, -644.18, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(970, 1147.74, -638.01, 1091.27,   0.00, 0.00, 0.00);
	CreateObject(970, 1143.63, -638.00, 1091.27,   0.00, 0.00, 0.00);
	CreateObject(970, 1139.54, -637.93, 1091.27,   0.00, 0.00, 0.00);
	CreateObject(970, 1137.50, -639.98, 1091.27,   0.00, 0.00, 90.00);
	CreateObject(19369, 1137.51, -645.19, 1088.22,   0.00, 0.00, 0.00);
	CreateObject(970, 1137.52, -644.10, 1091.27,   0.00, 0.00, 90.00);
	CreateObject(19369, 1145.41, -631.44, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1143.71, -629.93, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1143.73, -626.77, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1142.08, -625.23, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1138.88, -625.24, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1135.67, -625.24, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1132.66, -644.20, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1129.46, -644.19, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1126.93, -642.96, 1090.43,   0.00, 0.00, 40.00);
	CreateObject(19369, 1125.90, -640.14, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1125.91, -636.93, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1125.91, -633.75, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1125.92, -630.55, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1127.30, -628.23, 1090.43,   0.00, 0.00, -60.00);
	CreateObject(19369, 1130.07, -626.65, 1090.43,   0.00, 0.00, -60.00);
	CreateObject(19369, 1132.55, -625.66, 1090.43,   0.00, 0.00, 105.00);
	CreateObject(1775, 1143.09, -630.40, 1089.93,   0.00, 0.00, 270.00);
	CreateObject(1776, 1143.06, -628.96, 1089.93,   0.00, 0.00, 270.00);
	CreateObject(2001, 1143.13, -631.35, 1088.91,   0.00, 0.00, 0.00);
	CreateObject(1432, 1133.17, -642.52, 1089.01,   0.00, 0.00, 0.00);
	CreateObject(1432, 1129.21, -641.82, 1089.01,   0.00, 0.00, 0.00);
	CreateObject(1432, 1131.40, -638.98, 1089.01,   0.00, 0.00, 0.00);
	CreateObject(1432, 1135.09, -639.37, 1089.01,   0.00, 0.00, 0.00);
	CreateObject(1432, 1128.02, -637.67, 1089.01,   0.00, 0.00, 0.00);
	CreateObject(2001, 1126.35, -641.46, 1088.91,   0.00, 0.00, 0.00);
	CreateObject(2001, 1137.10, -643.68, 1088.91,   0.00, 0.00, 0.00);
	CreateObject(1432, 1130.51, -634.85, 1089.01,   0.00, 0.00, 0.00);
	CreateObject(1432, 1127.54, -632.56, 1089.01,   0.00, 0.00, 0.00);
	CreateObject(1432, 1128.86, -629.37, 1089.01,   0.00, 0.00, 0.00);
	CreateObject(1432, 1131.83, -631.57, 1089.01,   0.00, 0.00, 40.00);
	CreateObject(1432, 1132.67, -628.04, 1089.01,   0.00, 0.00, 40.00);
	CreateObject(1432, 1135.54, -629.42, 1089.01,   0.00, 0.00, 0.00);
	CreateObject(1432, 1139.35, -630.42, 1089.01,   0.00, 0.00, 0.00);
	CreateObject(1432, 1138.16, -627.12, 1089.01,   0.00, 0.00, 0.00);
	CreateObject(1432, 1135.00, -632.63, 1089.01,   0.00, 0.00, 0.00);
	CreateObject(1432, 1133.75, -635.86, 1089.01,   0.00, 0.00, 0.00);
	CreateObject(1432, 1138.62, -633.91, 1089.01,   0.00, 0.00, 40.00);
	CreateObject(1432, 1141.41, -626.98, 1089.01,   0.00, 0.00, 40.00);
	CreateObject(1432, 1141.86, -633.34, 1089.01,   0.00, 0.00, 40.00);
	CreateObject(1715, 1187.93, -628.59, 1088.91,   0.00, 0.00, -100.00);
	CreateObject(1715, 1185.63, -628.58, 1088.91,   0.00, 0.00, 90.00);
	CreateObject(2001, 1180.75, -629.62, 1088.91,   0.00, 0.00, 0.00);
	CreateObject(1726, 1181.06, -629.19, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1726, 1183.87, -627.20, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(14855, 1155.60, -600.05, 1093.41,   0.00, 0.00, 270.00);
	CreateObject(2001, 1154.21, -608.41, 1088.91,   0.00, 0.00, 0.00);
	CreateObject(2001, 1151.32, -608.40, 1088.91,   0.00, 0.00, 0.00);
	CreateObject(19379, 1156.09, -603.67, 1088.84,   0.00, 90.00, 0.00);
	CreateObject(19369, 1156.69, -606.27, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1159.86, -606.27, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1161.40, -604.73, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1161.25, -601.56, 1090.43,   0.00, 0.00, 5.00);
	CreateObject(19379, 1145.63, -603.56, 1088.84,   0.00, 90.00, 0.00);
	CreateObject(19379, 1145.62, -593.95, 1088.84,   0.00, 90.00, 0.00);
	CreateObject(19379, 1156.12, -594.03, 1088.84,   0.00, 90.00, 0.00);
	CreateObject(1502, 1149.84, -599.09, 1088.91,   0.00, 0.00, 90.00);
	CreateObject(19369, 1151.38, -597.45, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1154.51, -597.44, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1156.03, -595.77, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1157.69, -594.39, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1159.14, -596.08, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1160.14, -598.84, 1090.43,   0.00, 0.00, 40.00);
	CreateObject(19369, 1148.14, -597.46, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1146.03, -598.66, 1090.43,   0.00, 0.00, -40.00);
	CreateObject(19369, 1145.05, -601.34, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1146.35, -603.72, 1090.43,   0.00, 0.00, 60.00);
	CreateObject(19369, 1149.03, -605.43, 1090.43,   0.00, 0.00, 55.00);
	CreateObject(1536, 1145.12, -602.84, 1088.90,   0.00, 0.00, 90.00);
	CreateObject(1536, 1145.09, -599.84, 1088.90,   0.00, 0.00, 270.00);
	CreateObject(1714, 1156.06, -601.19, 1088.93,   0.00, 0.00, 0.00);
	CreateObject(1714, 1157.82, -601.17, 1088.93,   0.00, 0.00, 0.00);
	CreateObject(1714, 1159.66, -601.12, 1088.93,   0.00, 0.00, 0.00);
	CreateObject(1714, 1152.58, -600.68, 1088.93,   0.00, 0.00, -35.00);
	CreateObject(2190, 1151.89, -601.85, 1089.90,   0.00, 0.00, 150.00);
	CreateObject(2190, 1156.52, -602.63, 1089.90,   0.00, 0.00, 180.00);
	CreateObject(2190, 1158.23, -602.64, 1089.90,   0.00, 0.00, 180.00);
	CreateObject(2190, 1160.09, -602.65, 1089.90,   0.00, 0.00, 180.00);
	CreateObject(2007, 1156.64, -594.98, 1088.93,   0.00, 0.00, 0.00);
	CreateObject(2007, 1157.59, -594.98, 1088.93,   0.00, 0.00, 0.00);
	CreateObject(2007, 1158.54, -594.98, 1088.93,   0.00, 0.00, 0.00);
	CreateObject(2002, 1154.38, -598.08, 1088.93,   0.00, 0.00, 0.00);
	CreateObject(2000, 1154.94, -598.09, 1088.93,   0.00, 0.00, 0.00);
	CreateObject(2000, 1155.48, -598.10, 1088.93,   0.00, 0.00, 0.00);
	CreateObject(2001, 1156.10, -597.89, 1088.93,   0.00, 0.00, 0.00);
	CreateObject(2007, 1158.54, -597.11, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(2007, 1158.53, -596.15, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(1722, 1156.51, -616.03, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(2209, 1157.57, -616.24, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1722, 1156.48, -615.13, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(2209, 1160.17, -616.23, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1722, 1159.01, -616.03, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(1722, 1159.02, -615.14, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(2209, 1162.67, -616.23, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1722, 1161.52, -615.14, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(1722, 1161.51, -616.05, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(2209, 1162.67, -611.23, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1722, 1161.42, -611.07, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(1722, 1161.43, -610.15, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(2209, 1160.17, -611.23, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1722, 1158.92, -611.07, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(1722, 1158.93, -610.15, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(2209, 1157.67, -611.23, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1722, 1156.42, -611.07, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(1722, 1156.43, -610.15, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(14455, 1160.52, -617.69, 1090.47,   0.00, 0.00, 0.00);
	CreateObject(14455, 1162.67, -618.17, 1090.47,   0.00, 0.00, 180.00);
	CreateObject(1271, 1172.12, -645.35, 1089.23,   0.00, 0.00, 0.00);
	CreateObject(1271, 1171.35, -644.57, 1089.23,   0.00, 0.00, 0.00);
	CreateObject(1271, 1171.35, -644.57, 1089.93,   0.00, 0.00, 0.00);
	CreateObject(1271, 1171.35, -644.57, 1090.61,   0.00, 0.00, 0.00);
	CreateObject(1271, 1172.36, -644.48, 1089.23,   0.00, 0.00, 0.00);
	CreateObject(1271, 1173.25, -644.00, 1089.23,   0.00, 0.00, 0.00);
	CreateObject(1271, 1172.12, -645.35, 1089.93,   0.00, 0.00, 0.00);
	CreateObject(1271, 1172.36, -644.48, 1089.93,   0.00, 0.00, 0.00);
	CreateObject(1264, 1170.76, -641.85, 1089.35,   0.00, 0.00, 0.00);
	CreateObject(1264, 1170.76, -642.67, 1089.35,   0.00, 0.00, 0.00);
	CreateObject(1264, 1171.22, -642.32, 1089.35,   0.00, 0.00, 0.00);
	CreateObject(1264, 1171.35, -641.63, 1089.35,   0.00, 0.00, 0.00);
	CreateObject(1502, 1150.30, -612.44, 1088.91,   0.00, 0.00, 90.00);
	CreateObject(1502, 1150.27, -609.42, 1088.91,   0.00, 0.00, 270.00);
	CreateObject(3851, 1150.28, -613.03, 1093.37,   0.00, 0.00, 0.00);
	CreateObject(19379, 1145.02, -613.11, 1088.84,   0.00, 90.00, 0.00);
	CreateObject(19379, 1144.99, -620.45, 1088.85,   0.00, 90.00, 0.00);
	CreateObject(19379, 1134.54, -613.06, 1088.85,   0.00, 90.00, 0.00);
	CreateObject(19379, 1135.16, -603.55, 1088.85,   0.00, 90.00, 0.00);
	CreateObject(19379, 1134.57, -620.56, 1088.84,   0.00, 90.00, 0.00);
	CreateObject(19369, 1146.85, -607.22, 1090.43,   0.00, 0.00, 40.00);
	CreateObject(19369, 1144.81, -604.80, 1090.43,   0.00, 0.00, 40.00);
	CreateObject(19369, 1142.90, -604.44, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1139.69, -604.45, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1137.62, -605.58, 1090.43,   0.00, 0.00, -40.00);
	CreateObject(19369, 1136.69, -608.21, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1136.69, -611.40, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1136.67, -614.57, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1139.00, -614.17, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1142.21, -614.17, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1145.36, -614.16, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1148.56, -614.17, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1135.81, -614.18, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(1999, 1138.57, -608.84, 1088.93,   0.66, 0.48, 270.00);
	CreateObject(1714, 1137.50, -608.97, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(2894, 1138.57, -609.06, 1089.74,   0.00, 0.00, 90.00);
	CreateObject(14455, 1145.05, -613.86, 1090.47,   0.00, 0.00, 0.00);
	CreateObject(14455, 1139.34, -613.87, 1090.47,   0.00, 0.00, 0.00);
	CreateObject(2209, 1140.07, -605.84, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(2209, 1142.57, -605.84, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(2209, 1144.99, -606.93, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(2209, 1145.34, -610.61, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(2209, 1147.95, -610.55, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(2209, 1142.70, -610.60, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(2209, 1140.09, -610.60, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(1722, 1141.34, -611.65, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1722, 1141.35, -610.78, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1722, 1141.29, -606.84, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1722, 1141.30, -606.00, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1722, 1143.73, -605.93, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1722, 1143.76, -606.90, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1722, 1146.14, -608.05, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1722, 1146.15, -607.16, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1722, 1143.89, -610.86, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1722, 1143.89, -611.73, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1722, 1146.52, -610.76, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1722, 1146.56, -611.66, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1722, 1149.13, -610.69, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1722, 1149.17, -611.64, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(2894, 1145.10, -608.01, 1089.74,   0.00, 0.00, 270.00);
	CreateObject(2894, 1145.10, -607.00, 1089.74,   0.00, 0.00, 270.00);
	CreateObject(2894, 1142.80, -606.89, 1089.74,   0.00, 0.00, 270.00);
	CreateObject(2894, 1142.77, -605.95, 1089.74,   0.00, 0.00, 270.00);
	CreateObject(2894, 1140.24, -605.91, 1089.74,   0.00, 0.00, 270.00);
	CreateObject(2894, 1140.25, -606.77, 1089.74,   0.00, 0.00, 270.00);
	CreateObject(2894, 1142.84, -610.75, 1089.74,   0.00, 0.00, 270.00);
	CreateObject(2894, 1142.83, -611.69, 1089.74,   0.00, 0.00, 270.00);
	CreateObject(2894, 1140.13, -611.75, 1089.74,   0.00, 0.00, 270.00);
	CreateObject(2894, 1140.09, -610.80, 1089.74,   0.00, 0.00, 270.00);
	CreateObject(2894, 1145.34, -610.70, 1089.74,   0.00, 0.00, 270.00);
	CreateObject(2894, 1145.32, -611.70, 1089.74,   0.00, 0.00, 270.00);
	CreateObject(2894, 1148.03, -611.68, 1089.74,   0.00, 0.00, 270.00);
	CreateObject(2894, 1148.03, -610.80, 1089.74,   0.00, 0.00, 270.00);
	CreateObject(2894, 1162.63, -610.15, 1089.74,   0.00, 0.00, 270.00);
	CreateObject(2894, 1162.60, -611.18, 1089.74,   0.00, 0.00, 270.00);
	CreateObject(2894, 1160.12, -611.11, 1089.74,   0.00, 0.00, 270.00);
	CreateObject(2894, 1160.10, -610.11, 1089.74,   0.00, 0.00, 270.00);
	CreateObject(2894, 1157.64, -610.03, 1089.74,   0.00, 0.00, 270.00);
	CreateObject(2894, 1157.60, -611.07, 1089.74,   0.00, 0.00, 270.00);
	CreateObject(2894, 1157.48, -615.24, 1089.74,   0.00, 0.00, 270.00);
	CreateObject(2894, 1157.43, -616.13, 1089.74,   0.00, 0.00, 270.00);
	CreateObject(2894, 1160.09, -616.07, 1089.74,   0.00, 0.00, 270.00);
	CreateObject(2894, 1160.11, -615.17, 1089.74,   0.00, 0.00, 270.00);
	CreateObject(2894, 1162.60, -615.16, 1089.74,   0.00, 0.00, 270.00);
	CreateObject(2894, 1162.57, -616.07, 1089.74,   0.00, 0.00, 270.00);
	CreateObject(19370, 1148.31, -626.85, 1088.85,   0.00, 90.00, 0.00);
	CreateObject(19370, 1148.31, -629.85, 1088.85,   0.00, 90.00, 0.00);
	CreateObject(19370, 1145.56, -629.79, 1088.86,   0.00, 90.00, 0.00);
	CreateObject(19370, 1145.53, -626.78, 1088.84,   0.00, 90.00, 0.00);
	CreateObject(19369, 1140.00, -615.84, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1140.00, -619.04, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1138.48, -620.73, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1137.03, -620.48, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1137.03, -623.63, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1140.00, -622.32, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(1495, 1139.88, -623.98, 1088.93,   0.00, 0.00, 350.00);
	CreateObject(14455, 1149.97, -630.62, 1090.48,   0.00, 0.00, 90.00);
	CreateObject(14455, 1149.96, -624.91, 1090.48,   0.00, 0.00, 90.00);
	CreateObject(14455, 1144.02, -626.24, 1090.48,   0.00, 0.00, 270.00);
	CreateObject(0, 1148.10, -628.34, 1088.95,   0.00, 0.00, 0.00);
	CreateObject(1827, 1147.05, -628.70, 1088.94,   0.00, 0.00, 0.00);
	CreateObject(1726, 1148.06, -630.68, 1088.93,   0.00, 0.00, 180.00);
	CreateObject(2001, 1145.49, -630.83, 1088.95,   0.00, 0.00, 0.00);
	CreateObject(2001, 1148.71, -630.77, 1088.95,   0.00, 0.00, 0.00);
	CreateObject(1726, 1146.08, -626.71, 1088.93,   0.00, 0.00, 0.00);
	CreateObject(2001, 1145.41, -626.79, 1088.95,   0.00, 0.00, 0.00);
	CreateObject(2001, 1148.70, -626.68, 1088.95,   0.00, 0.00, 0.00);
	CreateObject(2894, 1146.88, -628.20, 1089.35,   0.00, 0.00, 0.00);
	CreateObject(2894, 1147.39, -628.38, 1089.35,   0.00, 0.00, 0.00);
	CreateObject(2894, 1146.63, -629.19, 1089.35,   0.00, 0.00, 0.00);
	CreateObject(2894, 1147.20, -628.93, 1089.35,   0.00, 0.00, 0.00);
	CreateObject(1744, 1138.21, -620.67, 1090.25,   0.00, 0.00, 0.00);
	CreateObject(1744, 1138.21, -620.67, 1091.25,   0.00, 0.00, 0.00);
	CreateObject(2894, 1139.14, -620.93, 1090.58,   0.00, 0.00, 0.00);
	CreateObject(2894, 1138.52, -620.92, 1090.58,   0.00, 0.00, 0.00);
	CreateObject(2894, 1138.50, -620.87, 1090.64,   0.00, 0.00, 0.00);
	CreateObject(2894, 1138.50, -620.87, 1090.69,   0.00, 0.00, 0.00);
	CreateObject(2894, 1138.50, -620.87, 1090.58,   0.00, 0.00, 0.00);
	CreateObject(1271, 1137.52, -624.49, 1089.28,   0.00, 0.00, 0.00);
	CreateObject(1271, 1137.52, -624.49, 1089.93,   0.00, 0.00, 0.00);
	CreateObject(1271, 1137.99, -623.57, 1089.28,   0.00, 0.00, 0.00);
	CreateObject(1271, 1137.66, -622.60, 1089.28,   0.00, 0.00, 0.00);
	CreateObject(1271, 1137.78, -621.71, 1089.28,   0.00, 0.00, 0.00);
	CreateObject(1271, 1137.78, -621.71, 1089.93,   0.00, 0.00, 0.00);
	CreateObject(1271, 1137.66, -622.60, 1089.93,   0.00, 0.00, 0.00);
	CreateObject(1999, 1141.68, -618.71, 1088.93,   0.66, 0.48, 270.00);
	CreateObject(1714, 1140.68, -618.89, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(2894, 1141.66, -618.87, 1089.74,   0.00, 0.00, 90.00);
	CreateObject(2209, 1143.05, -615.52, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(2209, 1143.06, -618.82, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(2209, 1142.99, -622.11, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(2209, 1145.41, -622.12, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(2209, 1145.43, -618.82, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(2209, 1145.41, -615.44, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(2209, 1147.61, -615.43, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(2209, 1147.58, -618.77, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(2209, 1147.56, -622.09, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(1722, 1144.25, -615.64, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1722, 1144.27, -616.60, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1722, 1146.60, -615.62, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1722, 1146.63, -616.47, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1722, 1146.61, -619.09, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1722, 1146.65, -619.96, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1722, 1144.33, -619.03, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1722, 1144.32, -619.85, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1722, 1144.15, -622.45, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1722, 1144.18, -623.23, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1722, 1146.60, -622.32, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1722, 1146.64, -623.14, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1722, 1148.75, -623.21, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1722, 1148.76, -622.36, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1722, 1148.73, -619.78, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1722, 1148.72, -618.88, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1722, 1148.83, -616.44, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1722, 1148.81, -615.40, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(19369, 1165.87, -642.84, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1165.86, -646.03, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1160.39, -642.84, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1160.41, -646.03, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1160.42, -649.21, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1165.84, -649.23, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1164.19, -650.65, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1160.99, -650.65, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(1727, 1161.25, -643.18, 1088.88,   0.00, 0.00, 90.00);
	CreateObject(2001, 1160.98, -641.60, 1088.91,   0.00, 0.00, 0.00);
	CreateObject(1727, 1161.26, -644.57, 1088.88,   0.00, 0.00, 90.00);
	CreateObject(1727, 1165.10, -643.50, 1088.88,   0.00, 0.00, 270.00);
	CreateObject(1727, 1165.10, -642.02, 1088.88,   0.00, 0.00, 270.00);
	CreateObject(2001, 1165.53, -641.51, 1088.91,   0.00, 0.00, 0.00);
	CreateObject(19369, 1165.31, -645.43, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(19369, 1160.60, -645.39, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(1502, 1162.20, -645.44, 1088.81,   0.00, 0.00, 0.00);
	CreateObject(3851, 1165.10, -645.35, 1093.41,   0.00, 0.00, 90.00);
	CreateObject(1999, 1162.64, -648.43, 1088.75,   0.00, 0.00, 0.00);
	CreateObject(1671, 1163.22, -649.29, 1089.19,   0.00, 0.00, 180.00);
	CreateObject(1671, 1163.12, -647.46, 1089.19,   0.00, 0.00, 0.00);
	CreateObject(2002, 1165.21, -646.34, 1088.72,   0.00, 0.00, 270.00);
	CreateObject(2001, 1165.50, -645.73, 1088.81,   0.00, 0.00, 0.00);
	CreateObject(2007, 1165.17, -649.69, 1088.70,   0.00, 0.00, 270.00);
	CreateObject(2007, 1161.04, -648.55, 1088.70,   0.00, 0.00, 90.00);
	CreateObject(2007, 1161.03, -649.54, 1088.70,   0.00, 0.00, 90.00);
	CreateObject(2001, 1165.48, -645.06, 1088.91,   0.00, 0.00, 0.00);
	CreateObject(2001, 1160.92, -645.12, 1088.91,   0.00, 0.00, 0.00);
	CreateObject(2001, 1160.78, -650.30, 1088.81,   0.00, 0.00, 0.00);
	CreateObject(2209, 1162.66, -620.94, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(2209, 1162.63, -626.43, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(2209, 1160.21, -626.41, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(2209, 1160.15, -620.92, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(2209, 1157.97, -620.97, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(2209, 1157.95, -626.46, 1088.93,   0.00, 0.00, 90.00);
	CreateObject(1722, 1161.40, -619.86, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(1722, 1161.34, -620.72, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(1722, 1159.00, -620.78, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(1722, 1158.93, -619.85, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(1722, 1161.46, -625.39, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(1722, 1161.41, -626.31, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(1722, 1158.91, -626.22, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(1722, 1158.89, -625.40, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(1722, 1156.74, -626.34, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(1722, 1156.76, -625.38, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(1722, 1156.80, -620.70, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(1722, 1156.74, -619.73, 1088.93,   0.00, 0.00, 270.00);
	CreateObject(2894, 1162.50, -619.85, 1089.74,   0.00, 0.00, 270.00);
	CreateObject(2894, 1162.54, -620.70, 1089.74,   0.00, 0.00, 270.00);
	CreateObject(2894, 1160.07, -620.76, 1089.74,   0.00, 0.00, 270.00);
	CreateObject(2894, 1160.08, -619.87, 1089.74,   0.00, 0.00, 270.00);
	CreateObject(2894, 1157.91, -620.73, 1089.74,   0.00, 0.00, 270.00);
	CreateObject(2894, 1157.91, -619.85, 1089.74,   0.00, 0.00, 270.00);
	CreateObject(2894, 1162.64, -625.39, 1089.74,   0.00, 0.00, 270.00);
	CreateObject(2894, 1162.64, -626.35, 1089.74,   0.00, 0.00, 270.00);
	CreateObject(2894, 1160.05, -626.11, 1089.74,   0.00, 0.00, 270.00);
	CreateObject(2894, 1160.10, -625.26, 1089.74,   0.00, 0.00, 270.00);
	CreateObject(2894, 1157.85, -625.31, 1089.74,   0.00, 0.00, 270.00);
	CreateObject(2894, 1157.80, -626.36, 1089.74,   0.00, 0.00, 270.00);
	CreateObject(1502, 1150.24, -618.66, 1088.94,   0.00, 0.00, 90.00);
	CreateObject(1502, 1150.19, -615.63, 1088.94,   0.00, 0.00, 270.00);
	CreateObject(19369, 1150.19, -620.23, 1090.42,   0.00, 0.00, 0.00);
	CreateObject(2414, 1142.16, -640.87, 1088.88,   0.00, 0.00, 180.00);
	CreateObject(2414, 1140.16, -640.86, 1088.88,   0.00, 0.00, 180.00);
	CreateObject(2414, 1144.17, -640.88, 1088.88,   0.00, 0.00, 180.00);
	CreateObject(2414, 1146.15, -640.88, 1088.88,   0.00, 0.00, 180.00);
	CreateObject(2414, 1148.11, -640.87, 1088.88,   0.00, 0.00, 180.00);
	CreateObject(19369, 1188.64, -631.57, 1090.43,   0.00, 0.00, 0.00);
	CreateObject(19369, 1187.87, -631.18, 1090.43,   0.00, 0.00, 90.00);
	CreateObject(2001, 1184.00, -629.65, 1088.91,   0.00, 0.00, 0.00);
	return 1;
}

public OnPlayerConnect(playerid){
    CarregarDados(playerid);
	return 1;
}


